﻿<%@ Page Language="C#" MasterPageFile="~/Views/Shared/Site.Master" Inherits="System.Web.Mvc.ViewPage<SearchViewModel>" %>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderID="TitleContent">Plan My Night - <%: !String.IsNullOrEmpty(Model.CriteriaDescription) ? Model.CriteriaDescription : "Search Activities"%></asp:Content>

<asp:Content runat="server" ContentPlaceHolderID="HtmlHeadContent">
    <% if(!String.IsNullOrEmpty(Model.KeywordsMetatag)) { %><meta name="keywords" content="<%=Html.AttributeEncode(Model.KeywordsMetatag)%>" /><% } %>
</asp:Content>

<asp:Content runat="server" ContentPlaceHolderID="MainContent">
    
    <% Html.RenderPartial("SearchForm", Model); %>
    
    <hr />
    
    <div class="dual">
        <%
            switch (Model.Criteria.Type)
            {
                case Microsoft.Samples.PlanMyNight.Entities.SearchType.Activity:
                    Html.RenderPartial("ActivitiesSearchResults", Model);
                    break;
                case Microsoft.Samples.PlanMyNight.Entities.SearchType.Itinerary:
                    Html.RenderPartial("ItinerariesSearchResults", Model);
                    break;
                case Microsoft.Samples.PlanMyNight.Entities.SearchType.ActivityItinerary:
                    Html.RenderPartial("ItinerariesByActivitySearchResults", Model);
                    break;
            }
        %>
            
        <% if(Ajax.JavaScriptEnabled()) %>
        <% { %>
            <%-- (Client Side Templates) --%>
            <% Html.RenderPartial("ClientTemplatesSearchResults"); %>
            <%-- (Client Side Templates) --%>
        <% } %>
           
        <% Html.RenderAction<ItinerariesController>(c => c.Current()); %>
    </div>
</asp:Content>